<?php

use Illuminate\Database\Seeder;
use App\Models\Country;

class CountriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Country::truncate();

        $countries=[
            ['AF', 'Afghanistan','أفغانستان','Afghan','أفغانستاني'],
            ['AL', 'Albania','ألبانيا','Albanian','ألباني'],
            ['AX', 'Aland Islands','جزر آلاند','Aland Islander','آلاندي'],
            ['DZ', 'Algeria','الجزائر','Algerian','جزائري'],
            ['AS', 'American Samoa','ساموا-الأمريكي','American Samoan','أمريكي سامواني'],
            ['AD', 'Andorra','أندورا','Andorran','أندوري'],
            ['AO', 'Angola','أنغولا','Angolan','أنقولي'],
            ['AI', 'Anguilla','أنغويلا','Anguillan','أنغويلي'],
            ['AQ', 'Antarctica','أنتاركتيكا','Antarctican','أنتاركتيكي'],
            ['AG', 'Antigua and Barbuda','أنتيغوا وبربودا','Antiguan','بربودي'],
            ['AR', 'Argentina','الأرجنتين','Argentinian','أرجنتيني'],
            ['AM', 'Armenia','أرمينيا','Armenian','أرميني'],
            ['AW', 'Aruba','أروبه','Aruban','أوروبهيني'],
            ['AU', 'Australia','أستراليا','Australian','أسترالي'],
            ['AT', 'Austria','النمسا','Austrian','نمساوي'],
            ['AZ', 'Azerbaijan','أذربيجان','Azerbaijani','أذربيجاني'],
            ['BS', 'Bahamas','الباهاماس','Bahamian','باهاميسي'],
            ['BH', 'Bahrain','البحرين','Bahraini','بحريني'],
            ['BD', 'Bangladesh','بنغلاديش','Bangladeshi','بنغلاديشي'],
            ['BB', 'Barbados','بربادوس','Barbadian','بربادوسي'],
            ['BY', 'Belarus','روسيا البيضاء','Belarusian','روسي'],
            ['BE', 'Belgium','بلجيكا','Belgian','بلجيكي'],
            ['BZ', 'Belize','بيليز','Belizean','بيليزي'],
            ['BJ', 'Benin','بنين','Beninese','بنيني'],
            ['BL', 'Saint Barthelemy','سان بارتيلمي','Saint Barthelmian','سان بارتيلمي'],
            ['BM', 'Bermuda','جزر برمودا','Bermudan','برمودي'],
            ['BT', 'Bhutan','بوتان','Bhutanese','بوتاني'],
            ['BO', 'Bolivia','بوليفيا','Bolivian','بوليفي'],
            ['BA', 'Bosnia and Herzegovina','البوسنة و الهرسك','Bosnian / Herzegovinian','بوسني/هرسكي'],
            ['BW', 'Botswana','بوتسوانا','Botswanan','بوتسواني'],
            ['BV', 'Bouvet Island','جزيرة بوفيه','Bouvetian','بوفيهي'],
            ['BR', 'Brazil','البرازيل','Brazilian','برازيلي'],
            ['IO', 'British Indian Ocean Territory','إقليم المحيط الهندي البريطاني','British Indian Ocean Territory','إقليم المحيط الهندي البريطاني'],
            ['BN', 'Brunei Darussalam','بروني','Bruneian','بروني'],
            ['BG', 'Bulgaria','بلغاريا','Bulgarian','بلغاري'],
            ['BF', 'Burkina Faso','بوركينا فاسو','Burkinabe','بوركيني'],
            ['BI', 'Burundi','بوروندي','Burundian','بورونيدي'],
            ['KH', 'Cambodia','كمبوديا','Cambodian','كمبودي'],
            ['CM', 'Cameroon','كاميرون','Cameroonian','كاميروني'],
            ['CA', 'Canada','كندا','Canadian','كندي'],
            ['CV', 'Cape Verde','الرأس الأخضر','Cape Verdean','الرأس الأخضر'],
            ['KY', 'Cayman Islands','جزر كايمان','Caymanian','كايماني'],
            ['CF', 'Central African Republic','جمهورية أفريقيا الوسطى','Central African','أفريقي'],
            ['TD', 'Chad','تشاد','Chadian','تشادي'],
            ['CL', 'Chile','شيلي','Chilean','شيلي'],
            ['CN', 'China','الصين','Chinese','صيني'],
            ['CX', 'Christmas Island','جزيرة عيد الميلاد','Christmas Islander','جزيرة عيد الميلاد'],
            ['CC', 'Cocos (Keeling) Islands','جزر كوكوس','Cocos Islander','جزر كوكوس'],
            ['CO', 'Colombia','كولومبيا','Colombian','كولومبي'],
            ['KM', 'Comoros','جزر القمر','Comorian','جزر القمر'],
            ['CG', 'Congo','الكونغو','Congolese','كونغي'],
            ['CK', 'Cook Islands','جزر كوك','Cook Islander','جزر كوك'],
            ['CR', 'Costa Rica','كوستاريكا','Costa Rican','كوستاريكي'],
            ['HR', 'Croatia','كرواتيا','Croatian','كوراتي'],
            ['CU', 'Cuba','كوبا','Cuban','كوبي'],
            ['CY', 'Cyprus','قبرص','Cypriot','قبرصي'],
            ['CW', 'Curaçao','كوراساو','Curacian','كوراساوي'],
            ['CZ', 'Czech Republic','الجمهورية التشيكية','Czech','تشيكي'],
            ['DK', 'Denmark','الدانمارك','Danish','دنماركي'],
            ['DJ', 'Djibouti','جيبوتي','Djiboutian','جيبوتي'],
            ['DM', 'Dominica','دومينيكا','Dominican','دومينيكي'],
            ['DO', 'Dominican Republic','الجمهورية الدومينيكية','Dominican','دومينيكي'],
            ['EC', 'Ecuador','إكوادور','Ecuadorian','إكوادوري'],
            ['EG', 'Egypt','مصر','Egyptian','مصري'],
            ['SV', 'El Salvador','إلسلفادور','Salvadoran','سلفادوري'],
            ['GQ', 'Equatorial Guinea','غينيا الاستوائي','Equatorial Guinean','غيني'],
            ['ER', 'Eritrea','إريتريا','Eritrean','إريتيري'],
            ['EE', 'Estonia','استونيا','Estonian','استوني'],
            ['ET', 'Ethiopia','أثيوبيا','Ethiopian','أثيوبي'],
            ['FK', 'Falkland Islands (Malvinas)','جزر فوكلاند','Falkland Islander','فوكلاندي'],
            ['FO', 'Faroe Islands','جزر فارو','Faroese','جزر فارو'],
            ['FJ', 'Fiji','فيجي','Fijian','فيجي'],
            ['FI', 'Finland','فنلندا','Finnish','فنلندي'],
            ['FR', 'France','فرنسا','French','فرنسي'],
            ['GF', 'French Guiana','غويانا الفرنسية','French Guianese','غويانا الفرنسية'],
            ['PF', 'French Polynesia','بولينيزيا الفرنسية','French Polynesian','بولينيزيي'],
            ['TF', 'French Southern and Antarctic Lands','أراض فرنسية جنوبية وأنتارتيكية','French','أراض فرنسية جنوبية وأنتارتيكية'],
            ['GA', 'Gabon','الغابون','Gabonese','غابوني'],
            ['GM', 'Gambia','غامبيا','Gambian','غامبي'],
            ['GE', 'Georgia','جيورجيا','Georgian','جيورجي'],
            ['DE', 'Germany','ألمانيا','German','ألماني'],
            ['GH', 'Ghana','غانا','Ghanaian','غاني'],
            ['GI', 'Gibraltar','جبل طارق','Gibraltar','جبل طارق'],
            ['GG', 'Guernsey','غيرنزي','Guernsian','غيرنزي'],
            ['GR', 'Greece','اليونان','Greek','يوناني'],
            ['GL', 'Greenland','جرينلاند','Greenlandic','جرينلاندي'],
            ['GD', 'Grenada','غرينادا','Grenadian','غرينادي'],
            ['GP', 'Guadeloupe','جزر جوادلوب','Guadeloupe','جزر جوادلوب'],
            ['GU', 'Guam','جوام','Guamanian','جوامي'],
            ['GT', 'Guatemala','غواتيمال','Guatemalan','غواتيمالي'],
            ['GN', 'Guinea','غينيا','Guinean','غيني'],
            ['GW', 'Guinea-Bissau','غينيا-بيساو','Guinea-Bissauan','غيني'],
            ['GY', 'Guyana','غيانا','Guyanese','غياني'],
            ['HT', 'Haiti','هايتي','Haitian','هايتي'],
            ['HM', 'Heard and Mc Donald Islands','جزيرة هيرد وجزر ماكدونالد','Heard and Mc Donald Islanders','جزيرة هيرد وجزر ماكدونالد'],
            ['HN', 'Honduras','هندوراس','Honduran','هندوراسي'],
            ['HK', 'Hong Kong','هونغ كونغ','Hongkongese','هونغ كونغي'],
            ['HU', 'Hungary','المجر','Hungarian','مجري'],
            ['IS', 'Iceland','آيسلندا','Icelandic','آيسلندي'],
            ['IN', 'India','الهند','Indian','هندي'],
            ['IM', 'Isle of Man','جزيرة مان','Manx','ماني'],
            ['ID', 'Indonesia','أندونيسيا','Indonesian','أندونيسيي'],
            ['IR', 'Iran','إيران','Iranian','إيراني'],
            ['IQ', 'Iraq','العراق','Iraqi','عراقي'],
            ['IE', 'Ireland','إيرلندا','Irish','إيرلندي'],
            ['IL', 'Israel','إسرائيل','Israeli','إسرائيلي'],
            ['IT', 'Italy','إيطاليا','Italian','إيطالي'],
            ['CI', 'Ivory Coast','ساحل العاج','Ivory Coastian','ساحل العاج'],
            ['JE', 'Jersey','جيرزي','Jersian','جيرزي'],
            ['JM', 'Jamaica','جمايكا','Jamaican','جمايكي'],
            ['JP', 'Japan','اليابان','Japanese','ياباني'],
            ['JO', 'Jordan','الأردن','Jordanian','أردني'],
            ['KZ', 'Kazakhstan','كازاخستان','Kazakh','كازاخستاني'],
            ['KE', 'Kenya','كينيا','Kenyan','كيني'],
            ['KI', 'Kiribati','كيريباتي','I-Kiribati','كيريباتي'],
            ['KP', 'Korea(North Korea)','كوريا الشمالية','North Korean','كوري'],
            ['KR', 'Korea(South Korea)','كوريا الجنوبية','South Korean','كوري'],
            ['XK', 'Kosovo','كوسوفو','Kosovar','كوسيفي'],
            ['KW', 'Kuwait','الكويت','Kuwaiti','كويتي'],
            ['KG', 'Kyrgyzstan','قيرغيزستان','Kyrgyzstani','قيرغيزستاني'],
            ['LA', 'Lao PDR','لاوس','Laotian','لاوسي'],
            ['LV', 'Latvia','لاتفيا','Latvian','لاتيفي'],
            ['LB', 'Lebanon','لبنان','Lebanese','لبناني'],
            ['LS', 'Lesotho','ليسوتو','Basotho','ليوسيتي'],
            ['LR', 'Liberia','ليبيريا','Liberian','ليبيري'],
            ['LY', 'Libya','ليبيا','Libyan','ليبي'],
            ['LI', 'Liechtenstein','ليختنشتين','Liechtenstein','ليختنشتيني'],
            ['LT', 'Lithuania','لتوانيا','Lithuanian','لتوانيي'],
            ['LU', 'Luxembourg','لوكسمبورغ','Luxembourger','لوكسمبورغي'],
            ['LK', 'Sri Lanka','سريلانكا','Sri Lankian','سريلانكي'],
            ['MO', 'Macau','ماكاو','Macanese','ماكاوي'],
            ['MK', 'Macedonia','مقدونيا','Macedonian','مقدوني'],
            ['MG', 'Madagascar','مدغشقر','Malagasy','مدغشقري'],
            ['MW', 'Malawi','مالاوي','Malawian','مالاوي'],
            ['MY', 'Malaysia','ماليزيا','Malaysian','ماليزي'],
            ['MV', 'Maldives','المالديف','Maldivian','مالديفي'],
            ['ML', 'Mali','مالي','Malian','مالي'],
            ['MT', 'Malta','مالطا','Maltese','مالطي'],
            ['MH', 'Marshall Islands','جزر مارشال','Marshallese','مارشالي'],
            ['MQ', 'Martinique','مارتينيك','Martiniquais','مارتينيكي'],
            ['MR', 'Mauritania','موريتانيا','Mauritanian','موريتانيي'],
            ['MU', 'Mauritius','موريشيوس','Mauritian','موريشيوسي'],
            ['YT', 'Mayotte','مايوت','Mahoran','مايوتي'],
            ['MX', 'Mexico','المكسيك','Mexican','مكسيكي'],
            ['FM', 'Micronesia','مايكرونيزيا','Micronesian','مايكرونيزيي'],
            ['MD', 'Moldova','مولدافيا','Moldovan','مولديفي'],
            ['MC', 'Monaco','موناكو','Monacan','مونيكي'],
            ['MN', 'Mongolia','منغوليا','Mongolian','منغولي'],
            ['ME', 'Montenegro','الجبل الأسود','Montenegrin','الجبل الأسود'],
            ['MS', 'Montserrat','مونتسيرات','Montserratian','مونتسيراتي'],
            ['MA', 'Morocco','المغرب','Moroccan','مغربي'],
            ['MZ', 'Mozambique','موزمبيق','Mozambican','موزمبيقي'],
            ['MM', 'Myanmar','ميانمار','Myanmarian','ميانماري'],
            ['NA', 'Namibia','ناميبيا','Namibian','ناميبي'],
            ['NR', 'Nauru','نورو','Nauruan','نوري'],
            ['NP', 'Nepal','نيبال','Nepalese','نيبالي'],
            ['NL', 'Netherlands','هولندا','Dutch','هولندي'],
            ['AN', 'Netherlands Antilles','جزر الأنتيل الهولندي','Dutch Antilier','هولندي'],
            ['NC', 'New Caledonia','كاليدونيا الجديدة','New Caledonian','كاليدوني'],
            ['NZ', 'New Zealand','نيوزيلندا','New Zealander','نيوزيلندي'],
            ['NI', 'Nicaragua','نيكاراجوا','Nicaraguan','نيكاراجوي'],
            ['NE', 'Niger','النيجر','Nigerien','نيجيري'],
            ['NG', 'Nigeria','نيجيريا','Nigerian','نيجيري'],
            ['NU', 'Niue','ني','Niuean','ني'],
            ['NF', 'Norfolk Island','جزيرة نورفولك','Norfolk Islander','نورفوليكي'],
            ['MP', 'Northern Mariana Islands','جزر ماريانا الشمالية','Northern Marianan','ماريني'],
            ['NO', 'Norway','النرويج','Norwegian','نرويجي'],
            ['OM', 'Oman','عمان','Omani','عماني'],
            ['PK', 'Pakistan','باكستان','Pakistani','باكستاني'],
            ['PW', 'Palau','بالاو','Palauan','بالاوي'],
            ['PS', 'Palestine','فلسطين','Palestinian','فلسطيني'],
            ['PA', 'Panama','بنما','Panamanian','بنمي'],
            ['PG', 'Papua New Guinea','بابوا غينيا الجديدة','Papua New Guinean','بابوي'],
            ['PY', 'Paraguay','باراغواي','Paraguayan','بارغاوي'],
            ['PE', 'Peru','بيرو','Peruvian','بيري'],
            ['PH', 'Philippines','الفليبين','Filipino','فلبيني'],
            ['PN', 'Pitcairn','بيتكيرن','Pitcairn Islander','بيتكيرني'],
            ['PL', 'Poland','بولونيا','Polish','بوليني'],
            ['PT', 'Portugal','البرتغال','Portuguese','برتغالي'],
            ['PR', 'Puerto Rico','بورتو ريكو','Puerto Rican','بورتي'],
            ['QA', 'Qatar','قطر','Qatari','قطري'],
            ['RE', 'Reunion Island','ريونيون','Reunionese','ريونيوني'],
            ['RO', 'Romania','رومانيا','Romanian','روماني'],
            ['RU', 'Russian','روسيا','Russian','روسي'],
            ['RW', 'Rwanda','رواندا','Rwandan','رواندا'],
            ['KN', 'Saint Kitts and Nevis','سانت كيتس ونيفس,','Kittitian/Nevisian','سانت كيتس ونيفس'],
            ['MF', 'Saint Martin (French part)','ساينت مارتن فرنسي','St. Martian(French)','ساينت مارتني فرنسي'],
            ['SX', 'Sint Maarten (Dutch part)','ساينت مارتن هولندي','St. Martian(Dutch)','ساينت مارتني هولندي'],
            ['LC', 'Saint Pierre and Miquelon','سان بيير وميكلون','St. Pierre and Miquelon','سان بيير وميكلوني'],
            ['VC', 'Saint Vincent and the Grenadines','سانت فنسنت وجزر غرينادين','Saint Vincent and the Grenadines','سانت فنسنت وجزر غرينادين'],
            ['WS', 'Samoa','ساموا','Samoan','ساموي'],
            ['SM', 'San Marino','سان مارينو','Sammarinese','ماريني'],
            ['ST', 'Sao Tome and Principe','ساو تومي وبرينسيبي','Sao Tomean','ساو تومي وبرينسيبي'],
            ['SA', 'Saudi Arabia','المملكة العربية السعودية','Saudi Arabian','سعودي'],
            ['SN', 'Senegal','السنغال','Senegalese','سنغالي'],
            ['RS', 'Serbia','صربيا','Serbian','صربي'],
            ['SC', 'Seychelles','سيشيل','Seychellois','سيشيلي'],
            ['SL', 'Sierra Leone','سيراليون','Sierra Leonean','سيراليوني'],
            ['SG', 'Singapore','سنغافورة','Singaporean','سنغافوري'],
            ['SK', 'Slovakia','سلوفاكيا','Slovak','سولفاكي'],
            ['SI', 'Slovenia','سلوفينيا','Slovenian','سولفيني'],
            ['SB', 'Solomon Islands','جزر سليمان','Solomon Island','جزر سليمان'],
            ['SO', 'Somalia','الصومال','Somali','صومالي'],
            ['ZA', 'South Africa','جنوب أفريقيا','South African','أفريقي'],
            ['GS', 'South Georgia and the South Sandwich','المنطقة القطبية الجنوبية','South Georgia and the South Sandwich','لمنطقة القطبية الجنوبية'],
            ['SS', 'South Sudan','السودان الجنوبي','South Sudanese','سوادني جنوبي'],
            ['ES', 'Spain','إسبانيا','Spanish','إسباني'],
            ['SH', 'Saint Helena','سانت هيلانة','St. Helenian','هيلاني'],
            ['SD', 'Sudan','السودان','Sudanese','سوداني'],
            ['SR', 'Suriname','سورينام','Surinamese','سورينامي'],
            ['SJ', 'Svalbard and Jan Mayen','سفالبارد ويان ماين','Svalbardian/Jan Mayenian','سفالبارد ويان ماين'],
            ['SZ', 'Swaziland','سوازيلند','Swazi','سوازيلندي'],
            ['SE', 'Sweden','السويد','Swedish','سويدي'],
            ['CH', 'Switzerland','سويسرا','Swiss','سويسري'],
            ['SY', 'Syria','سوريا','Syrian','سوري'],
            ['TW', 'Taiwan','تايوان','Taiwanese','تايواني'],
            ['TJ', 'Tajikistan','طاجيكستان','Tajikistani','طاجيكستاني'],
            ['TZ', 'Tanzania','تنزانيا','Tanzanian','تنزانيي'],
            ['TH', 'Thailand','تايلندا','Thai','تايلندي'],
            ['TL', 'Timor-Leste','تيمور الشرقية','Timor-Lestian','تيموري'],
            ['TG', 'Togo','توغو','Togolese','توغي'],
            ['TK', 'Tokelau','توكيلاو','Tokelaian','توكيلاوي'],
            ['TO', 'Tonga','تونغا','Tongan','تونغي'],
            ['TT', 'Trinidad and Tobago','ترينيداد وتوباغو','Trinidadian/Tobagonian','ترينيداد وتوباغو'],
            ['TN', 'Tunisia','تونس','Tunisian','تونسي'],
            ['TR', 'Turkey','تركيا','Turkish','تركي'],
            ['TM', 'Turkmenistan','تركمانستان','Turkmen','تركمانستاني'],
            ['TC', 'Turks and Caicos Islands','جزر توركس وكايكوس','Turks and Caicos Islands','جزر توركس وكايكوس'],
            ['TV', 'Tuvalu','توفالو','Tuvaluan','توفالي'],
            ['UG', 'Uganda','أوغندا','Ugandan','أوغندي'],
            ['UA', 'Ukraine','أوكرانيا','Ukrainian','أوكراني'],
            ['AE', 'United Arab Emirates','الإمارات العربية المتحدة','Emirati','إماراتي'],
            ['GB', 'United Kingdom','المملكة المتحدة','British','بريطاني'],
            ['US', 'United States','الولايات المتحدة','American','أمريكي'],
            ['UM', 'US Minor Outlying Islands','قائمة الولايات والمناطق الأمريكية','US Minor Outlying Islander','أمريكي'],
            ['UY', 'Uruguay','أورغواي','Uruguayan','أورغواي'],
            ['UZ', 'Uzbekistan','أوزباكستان','Uzbek','أوزباكستاني'],
            ['VU', 'Vanuatu','فانواتو','Vanuatuan','فانواتي'],
            ['VE', 'Venezuela','فنزويلا','Venezuelan','فنزويلي'],
            ['VN', 'Vietnam','فيتنام','Vietnamese','فيتنامي'],
            ['VI', 'Virgin Islands (U.S.)','الجزر العذراء الأمريكي','American Virgin Islander','أمريكي'],
            ['VA', 'Vatican City','فنزويلا','Vatican','فاتيكاني'],
            ['WF', 'Wallis and Futuna Islands','والس وفوتونا','Wallisian/Futunan','فوتوني'],
            ['EH', 'Western Sahara','الصحراء الغربية','Sahrawian','صحراوي'],
            ['YE', 'Yemen','اليمن','Yemeni','يمني'],
            ['ZM', 'Zambia','زامبيا','Zambian','زامبياني'],
            ['ZW', 'Zimbabwe','زمبابوي','Zimbabwean','زمبابوي'],
        ];



        foreach($countries as $country)
        {
            Country::create([
                'name'=>$country[1],
                'nationality'=>$country[3],
            ]);
        }
    }
}
