<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Events\V1\Subscription;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 *
 * @property string $accountSid
 * @property string $type
 * @property int $version
 * @property string $subscriptionSid
 * @property string $url
 */
class SubscribedEventInstance extends InstanceResource {
    /**
     * Initialize the SubscribedEventInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $subscriptionSid Subscription SID.
     */
    public function __construct(Version $version, array $payload, string $subscriptionSid) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'type' => Values::array_get($payload, 'type'),
            'version' => Values::array_get($payload, 'version'),
            'subscriptionSid' => Values::array_get($payload, 'subscription_sid'),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = ['subscriptionSid' => $subscriptionSid, ];
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Events.V1.SubscribedEventInstance]';
    }
}